/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils;

import filenet.vw.api.VWSession;
import filenet.ws.api.WSDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.wsdl.WSDLException;

public class VWWebServiceCache {
    private VWSession m_session = null;
    private HashMap m_hash = null;

    public VWWebServiceCache(VWSession session) {
        this.m_session = session;
        this.m_hash = new HashMap();
    }

    public synchronized WSDefinition add(String url) throws WSDLException, Exception {
        WSDefinition wsDef = null;
        if (url != null && url.length() > 0 && (wsDef = WSDefinition.getWSDefinition(this.m_session, url)) != null) {
            this.m_hash.put(url, wsDef);
        }
        return wsDef;
    }

    public synchronized void add(WSDefinition webServiceDefinition) {
        if (webServiceDefinition != null) {
            String url = webServiceDefinition.getWsdlURI();
            this.m_hash.put(url, webServiceDefinition);
        }
    }

    public synchronized WSDefinition get(String url) throws Exception {
        WSDefinition wsDef = null;
        if (url != null && url.length() > 0 && (wsDef = (WSDefinition)this.m_hash.get(url)) == null) {
            wsDef = this.add(url);
        }
        return wsDef;
    }

    public synchronized void remove(String url) {
        if (url != null && url.length() > 0) {
            Object obj = null;
            obj = this.m_hash.remove(url);
            if (obj != null && obj instanceof WSDefinition) {
                ((WSDefinition)obj).releaseReferences();
                Object var2_2 = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAll() {
        HashMap hashMap = this.m_hash;
        synchronized (hashMap) {
            Set set = this.m_hash.keySet();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object obj = this.m_hash.remove(iterator.next());
                    if (obj == null || !(obj instanceof WSDefinition)) continue;
                    ((WSDefinition)obj).releaseReferences();
                    obj = null;
                }
            }
            this.m_hash.clear();
        }
    }
}

